/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.FluentCacheConfigurationBuilder;
import org.ehcache.config.ResourcePools;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public interface FluentConfigurationBuilder<B extends FluentConfigurationBuilder<?>>
extends Builder<Configuration> {
    public CacheConfiguration<?, ?> getCache(String var1);

    public B withCache(String var1, CacheConfiguration<?, ?> var2);

    public B withSharedResources(ResourcePools var1);

    default public B withSharedResources(Builder<? extends ResourcePools> builder) {
        return this.withSharedResources(builder.build());
    }

    public B updateSharedResources(UnaryOperator<ResourcePools> var1);

    default public B withCache(String alias, Builder<? extends CacheConfiguration<?, ?>> builder) {
        return this.withCache(alias, builder.build());
    }

    public B withoutCache(String var1);

    public B updateCache(String var1, UnaryOperator<FluentCacheConfigurationBuilder<?, ?, ?>> var2) throws IllegalArgumentException;

    public B updateCaches(UnaryOperator<FluentCacheConfigurationBuilder<?, ?, ?>> var1);

    default public <C extends ServiceCreationConfiguration<?, ?>> C getService(Class<C> configurationType) throws IllegalArgumentException {
        Collection<C> services = this.getServices(configurationType);
        switch (services.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (C)((ServiceCreationConfiguration)services.iterator().next());
            }
        }
        throw new IllegalArgumentException(configurationType + " does not identify a unique service configuration: " + services);
    }

    public <C extends ServiceCreationConfiguration<?, ?>> Collection<C> getServices(Class<C> var1);

    public B withService(ServiceCreationConfiguration<?, ?> var1);

    default public B withService(Builder<? extends ServiceCreationConfiguration<?, ?>> builder) {
        return this.withService(builder.build());
    }

    default public B withoutServices(Class<? extends ServiceCreationConfiguration<?, ?>> clazz) {
        return this.withoutServices(clazz, c -> true);
    }

    public <C extends ServiceCreationConfiguration<?, ?>> B withoutServices(Class<C> var1, Predicate<? super C> var2);

    public <R, C extends ServiceCreationConfiguration<?, R>> B updateServices(Class<C> var1, UnaryOperator<R> var2) throws IllegalStateException;

    public ClassLoader getClassLoader();

    public B withClassLoader(ClassLoader var1);

    public B withDefaultClassLoader();
}

