/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav.test;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.servlet.jackrabbit.JackrabbitRepositoryServlet;
import org.apache.jackrabbit.standalone.Main;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.NCSARequestLog;
import org.mortbay.jetty.RequestLog;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;

final class JackrabbitMain {
    private final Options options = new Options();
    private final CommandLine command;
    private final RequestLogHandler accessLog = new RequestLogHandler();
    private final WebAppContext webapp = new WebAppContext();
    private final Connector connector = new SocketConnector();
    private final Server server = new Server();
    private FileAppender jackrabbitAppender;
    private FileAppender jettyAppender;

    public static void main(String[] args) throws Exception {
        new JackrabbitMain(args).run();
    }

    public JackrabbitMain(String[] args) throws ParseException {
        this.options.addOption("?", "help", false, "print this message");
        this.options.addOption("n", "notice", false, "print copyright notices");
        this.options.addOption("l", "license", false, "print license information");
        this.options.addOption("q", "quiet", false, "disable console output");
        this.options.addOption("d", "debug", false, "enable debug logging");
        this.options.addOption("h", "host", true, "IP address of the HTTP server");
        this.options.addOption("p", "port", true, "TCP port of the HTTP server (8080)");
        this.options.addOption("f", "file", true, "location of this jar file");
        this.options.addOption("r", "repo", true, "repository directory (jackrabbit)");
        this.options.addOption("c", "conf", true, "repository configuration file");
        this.command = new GnuParser().parse(this.options, args);
    }

    private void copyToOutput(String resource) throws IOException {
        try (InputStream stream = JackrabbitMain.class.getResourceAsStream(resource);){
            IOUtils.copy((InputStream)stream, (OutputStream)System.out);
        }
    }

    private URL getResource(String name) {
        URL res = Thread.currentThread().getContextClassLoader().getResource(name);
        if (res == null) {
            res = this.getClass().getResource(name);
        }
        return res;
    }

    private void message(String message) {
        if (!this.command.hasOption("quiet")) {
            System.out.println(message);
        }
    }

    private void prepareAccessLog(File log) {
        NCSARequestLog ncsa = new NCSARequestLog(new File(log, "access.log.yyyy_mm_dd").getPath());
        ncsa.setFilenameDateFormat("yyyy-MM-dd");
        this.accessLog.setRequestLog((RequestLog)ncsa);
    }

    private void prepareConnector() {
        String port = this.command.getOptionValue("port", "8080");
        this.connector.setPort(Integer.parseInt(port));
        String host = this.command.getOptionValue("host");
        if (host != null) {
            this.connector.setHost(host);
        }
    }

    private void prepareServerLog(File log) throws IOException {
        PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} *%-5p* %c{1}: %m%n");
        Logger jackrabbitLog = Logger.getRootLogger();
        this.jackrabbitAppender = new FileAppender((Layout)layout, new File(log, "jackrabbit.log").getPath());
        this.jackrabbitAppender.setThreshold((Priority)Level.ALL);
        jackrabbitLog.addAppender((Appender)this.jackrabbitAppender);
        Logger jettyLog = Logger.getLogger((String)"org.mortbay.log");
        this.jettyAppender = new FileAppender((Layout)layout, new File(log, "jetty.log").getPath());
        this.jettyAppender.setThreshold((Priority)Level.ALL);
        jettyLog.addAppender((Appender)this.jettyAppender);
        jettyLog.setAdditivity(false);
        System.setProperty("derby.stream.error.file", new File(log, "derby.log").getPath());
    }

    private void prepareShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    JackrabbitMain.this.shutdown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void prepareWebapp(File file, File repository, File tmp) {
        this.webapp.setContextPath("/");
        this.webapp.setWar(file.getPath());
        this.webapp.setClassLoader(JackrabbitMain.class.getClassLoader());
        URL res = this.getResource("/jcrweb.xml");
        if (res != null) {
            this.webapp.setDescriptor(res.toString());
        }
        this.webapp.setExtractWAR(false);
        this.webapp.setTempDirectory(tmp);
        ServletHolder servlet = new ServletHolder(JackrabbitRepositoryServlet.class);
        servlet.setInitOrder(1);
        servlet.setInitParameter("repository.home", repository.getAbsolutePath());
        String conf = this.command.getOptionValue("conf");
        if (conf != null) {
            servlet.setInitParameter("repository.config", conf);
        }
        this.webapp.addServlet(servlet, "/repository.properties");
    }

    public void run() throws Exception {
        File file;
        String defaultFile = "jackrabbit-standalone.jar";
        URL location = Main.class.getProtectionDomain().getCodeSource().getLocation();
        if (location != null && "file".equals(location.getProtocol()) && (file = new File(location.getPath())).isFile()) {
            defaultFile = location.getPath();
        }
        file = new File(this.command.getOptionValue("file", defaultFile));
        if (this.command.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("java -jar " + file.getName(), this.options, true);
        } else if (this.command.hasOption("notice")) {
            this.copyToOutput("/META-INF/NOTICE.txt");
        } else if (this.command.hasOption("license")) {
            this.copyToOutput("/META-INF/LICENSE.txt");
        } else {
            this.message("Welcome to Apache Jackrabbit!");
            this.message("-------------------------------");
            File repository = new File(this.command.getOptionValue("repo", "target/test/jackrabbit"));
            this.message("Using repository directory " + repository);
            repository.mkdirs();
            File tmp = new File(repository, "tmp");
            tmp.mkdir();
            File log = new File(repository, "log");
            log.mkdir();
            this.message("Writing log messages to " + log);
            this.prepareServerLog(log);
            this.message("Starting the server...");
            this.prepareWebapp(file, repository, tmp);
            this.accessLog.setHandler((Handler)this.webapp);
            this.prepareAccessLog(log);
            this.server.setHandler((Handler)this.accessLog);
            this.prepareConnector();
            this.server.addConnector(this.connector);
            this.prepareShutdown();
            try {
                this.server.start();
                String host = this.connector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                this.message("Apache Jackrabbit is now running at http://" + host + ":" + this.connector.getPort() + "/");
            }
            catch (Throwable t) {
                System.err.println("Unable to start the server: " + t.getMessage());
                System.exit(1);
            }
        }
    }

    public void shutdown() throws Exception, InterruptedException {
        this.message("Shutting down the server...");
        this.server.setGracefulShutdown(5);
        this.server.stop();
        Logger.getRootLogger().removeAppender((Appender)this.jackrabbitAppender);
        Logger.getLogger((String)"org.mortbay.log").removeAppender((Appender)this.jettyAppender);
        this.jackrabbitAppender.close();
        this.jettyAppender.close();
        this.server.join();
        this.message("-------------------------------");
        this.message("Goodbye from Apache Jackrabbit!");
    }
}

