/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.Objects;
import org.apache.commons.statistics.distribution.HypergeometricDistribution;
import org.apache.commons.statistics.inference.AlternativeHypothesis;
import org.apache.commons.statistics.inference.Arguments;
import org.apache.commons.statistics.inference.BaseSignificanceResult;
import org.apache.commons.statistics.inference.Searches;
import org.apache.commons.statistics.inference.SignificanceResult;

public final class FisherExactTest {
    private static final FisherExactTest DEFAULT = new FisherExactTest(AlternativeHypothesis.TWO_SIDED);
    private final AlternativeHypothesis alternative;

    private FisherExactTest(AlternativeHypothesis alternative) {
        this.alternative = alternative;
    }

    public static FisherExactTest withDefaults() {
        return DEFAULT;
    }

    public FisherExactTest with(AlternativeHypothesis v) {
        return new FisherExactTest(Objects.requireNonNull(v));
    }

    public double statistic(int[][] table) {
        Arguments.checkTable(table);
        double a = table[0][0];
        double b = table[0][1];
        double c = table[1][0];
        double d = table[1][1];
        return a * d / (b * c);
    }

    public SignificanceResult test(int[][] table) {
        Arguments.checkTable(table);
        int a = table[0][0];
        int b = table[0][1];
        int c = table[1][0];
        int d = table[1][1];
        double statistic = (double)a * (double)d / ((double)b * (double)c);
        int nn = a + b + c + d;
        int k = a + b;
        int n = a + c;
        HypergeometricDistribution distribution = HypergeometricDistribution.of((int)nn, (int)k, (int)n);
        double p = this.alternative == AlternativeHypothesis.GREATER_THAN ? distribution.survivalProbability(a - 1) : (this.alternative == AlternativeHypothesis.LESS_THAN ? distribution.cumulativeProbability(a) : FisherExactTest.twoSidedTest(a, distribution));
        return new BaseSignificanceResult(statistic, p);
    }

    private static double twoSidedTest(int k, HypergeometricDistribution distribution) {
        int nn = distribution.getPopulationSize();
        int kk = distribution.getNumberOfSuccesses();
        int n = distribution.getSampleSize();
        double v = ((double)n + 1.0) * ((double)kk + 1.0) / ((double)nn + 2.0);
        int m1 = (int)Math.ceil(v) - 1;
        int m2 = (int)Math.floor(v);
        if (k < m1) {
            double pk = distribution.logProbability(k);
            int i = Searches.searchDescending(m2, distribution.getSupportUpperBound(), pk, arg_0 -> ((HypergeometricDistribution)distribution).logProbability(arg_0));
            return distribution.cumulativeProbability(k) + distribution.survivalProbability(i - 1);
        }
        if (k > m2) {
            double pk = distribution.logProbability(k);
            int i = Searches.searchAscending(distribution.getSupportLowerBound(), m1, pk, arg_0 -> ((HypergeometricDistribution)distribution).logProbability(arg_0));
            return distribution.cumulativeProbability(i) + distribution.survivalProbability(k - 1);
        }
        double pk = distribution.probability(k);
        double pm = distribution.probability(k == m1 ? m2 : m1);
        return pm > pk ? 1.0 - pm : 1.0;
    }
}

