/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.introspection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class JexlSandbox {
    public static final String NULL = "?";
    static final Names ALLOW_NAMES = new Names(){

        @Override
        public boolean add(String name) {
            return false;
        }

        public String toString() {
            return "allowAll";
        }
    };
    private static final Names BLOCK_NAMES = new Names(){

        @Override
        public boolean add(String name) {
            return false;
        }

        @Override
        public String get(String name) {
            return name == null ? JexlSandbox.NULL : null;
        }

        public String toString() {
            return "blockAll";
        }
    };
    private static final Permissions BLOCK_ALL = new Permissions(false, BLOCK_NAMES, BLOCK_NAMES, BLOCK_NAMES);
    private static final Permissions ALLOW_ALL = new Permissions(false, ALLOW_NAMES, ALLOW_NAMES, ALLOW_NAMES);
    private final Map<String, Permissions> sandbox;
    private final boolean inherit;
    private final boolean allow;

    public JexlSandbox() {
        this(true, false, null);
    }

    public JexlSandbox(boolean ab) {
        this(ab, false, null);
    }

    public JexlSandbox(boolean ab, boolean inh) {
        this(ab, inh, null);
    }

    private JexlSandbox(boolean ab, boolean inh, Map<String, Permissions> map) {
        this.allow = ab;
        this.inherit = inh;
        this.sandbox = map != null ? map : new HashMap();
    }

    static Class<?> forName(String cname) {
        try {
            return Class.forName(cname);
        }
        catch (Exception xany) {
            return null;
        }
    }

    public Permissions allow(String clazz) {
        return this.permissions(clazz, true, true, true);
    }

    public Permissions block(String clazz) {
        return this.permissions(clazz, false, false, false);
    }

    public JexlSandbox copy() {
        ConcurrentHashMap<String, Permissions> map = new ConcurrentHashMap<String, Permissions>();
        for (Map.Entry<String, Permissions> entry : this.sandbox.entrySet()) {
            map.put(entry.getKey(), entry.getValue().copy());
        }
        return new JexlSandbox(this.allow, this.inherit, map);
    }

    public String execute(Class<?> clazz, String name) {
        String m = this.get(clazz).execute().get(name);
        return "".equals(name) && m != null ? clazz.getName() : m;
    }

    @Deprecated
    public String execute(String clazz, String name) {
        String m = this.get(clazz).execute().get(name);
        return "".equals(name) && m != null ? clazz : m;
    }

    public Permissions get(String clazz) {
        return this.get(JexlSandbox.forName(clazz));
    }

    public Permissions get(Class<?> clazz) {
        return this.compute(clazz, true);
    }

    private static Permissions inheritable(Permissions p) {
        return p != null && p.isInheritable() ? p : null;
    }

    private Permissions compute(Class<?> clazz, boolean store) {
        if (clazz == null) {
            return BLOCK_ALL;
        }
        String className = clazz.getName();
        Permissions permissions = this.sandbox.get(className);
        if (permissions == null) {
            if (this.inherit) {
                Class<?> superClazz;
                Class<?>[] interfaces = clazz.getInterfaces();
                for (int i = 0; permissions == null && i < interfaces.length; ++i) {
                    permissions = JexlSandbox.inheritable(this.compute(interfaces[i], false));
                }
                if (permissions == null && null != (superClazz = clazz.getSuperclass())) {
                    permissions = JexlSandbox.inheritable(this.compute(superClazz, false));
                }
            }
            if (permissions == null) {
                Permissions permissions2 = permissions = this.allow ? ALLOW_ALL : BLOCK_ALL;
            }
            if (store) {
                this.sandbox.put(className, permissions);
            }
        }
        return permissions;
    }

    public Permissions permissions(String clazz, boolean readFlag, boolean writeFlag, boolean executeFlag) {
        return this.permissions(clazz, this.inherit, readFlag, writeFlag, executeFlag);
    }

    public Permissions permissions(String clazz, boolean inhf, boolean readf, boolean writef, boolean execf) {
        Permissions box = new Permissions(inhf, readf, writef, execf);
        this.sandbox.put(clazz, box);
        return box;
    }

    public String read(Class<?> clazz, String name) {
        return this.get(clazz).read().get(name);
    }

    public String write(Class<?> clazz, String name) {
        return this.get(clazz).write().get(name);
    }

    @Deprecated
    public String write(String clazz, String name) {
        return this.get(clazz).write().get(name);
    }

    @Deprecated
    public Permissions black(String clazz) {
        return this.block(clazz);
    }

    @Deprecated
    public String read(String clazz, String name) {
        return this.get(clazz).read().get(name);
    }

    @Deprecated
    public Permissions white(String clazz) {
        return this.allow(clazz);
    }

    public static final class Permissions {
        private final boolean inheritable;
        private final Names read;
        private final Names write;
        private final Names execute;

        Permissions(boolean inherit, boolean readFlag, boolean writeFlag, boolean executeFlag) {
            this(inherit, readFlag ? new AllowSet() : new BlockSet(), writeFlag ? new AllowSet() : new BlockSet(), executeFlag ? new AllowSet() : new BlockSet());
        }

        Permissions(boolean inherit, Names nread, Names nwrite, Names nexecute) {
            this.read = nread != null ? nread : ALLOW_NAMES;
            this.write = nwrite != null ? nwrite : ALLOW_NAMES;
            this.execute = nexecute != null ? nexecute : ALLOW_NAMES;
            this.inheritable = inherit;
        }

        Permissions copy() {
            return new Permissions(this.inheritable, this.read.copy(), this.write.copy(), this.execute.copy());
        }

        public Names execute() {
            return this.execute;
        }

        public Permissions execute(String ... methodNames) {
            for (String methodName : methodNames) {
                this.execute.add(methodName);
            }
            return this;
        }

        public boolean isInheritable() {
            return this.inheritable;
        }

        public Names read() {
            return this.read;
        }

        public Permissions read(String ... propertyNames) {
            for (String propertyName : propertyNames) {
                this.read.add(propertyName);
            }
            return this;
        }

        public Names write() {
            return this.write;
        }

        public Permissions write(String ... propertyNames) {
            for (String propertyName : propertyNames) {
                this.write.add(propertyName);
            }
            return this;
        }
    }

    public static abstract class Names {
        public abstract boolean add(String var1);

        public boolean alias(String name, String alias) {
            return false;
        }

        protected Names copy() {
            return this;
        }

        public String get(String name) {
            return name;
        }
    }

    @Deprecated
    public static final class WhiteSet
    extends AllowSet {
    }

    @Deprecated
    public static final class BlackSet
    extends BlockSet {
    }

    static class BlockSet
    extends Names {
        private Set<String> names;

        BlockSet() {
        }

        @Override
        public boolean add(String name) {
            if (this.names == null) {
                this.names = new HashSet<String>();
            }
            return this.names.add(name);
        }

        @Override
        protected Names copy() {
            BlockSet copy = new BlockSet();
            copy.names = this.names == null ? null : new HashSet<String>(this.names);
            return copy;
        }

        @Override
        public String get(String name) {
            if (this.names != null && !this.names.contains(name)) {
                return name;
            }
            if (name != null) {
                return null;
            }
            return JexlSandbox.NULL;
        }

        public String toString() {
            return "block{" + (this.names == null ? "all" : Objects.toString(this.names)) + "}";
        }
    }

    static class AllowSet
    extends Names {
        private Map<String, String> names;

        AllowSet() {
        }

        @Override
        public boolean add(String name) {
            if (this.names == null) {
                this.names = new HashMap<String, String>();
            }
            return this.names.put(name, name) == null;
        }

        @Override
        public boolean alias(String name, String alias) {
            if (this.names == null) {
                this.names = new HashMap<String, String>();
            }
            return this.names.put(alias, name) == null;
        }

        @Override
        protected Names copy() {
            AllowSet copy = new AllowSet();
            copy.names = this.names == null ? null : new HashMap<String, String>(this.names);
            return copy;
        }

        @Override
        public String get(String name) {
            if (this.names == null) {
                return name;
            }
            String actual = this.names.get(name);
            if (name == null && actual == null && !this.names.containsKey(null)) {
                return JexlSandbox.NULL;
            }
            return actual;
        }

        public String toString() {
            return "allow{" + (this.names == null ? "all" : Objects.toString(this.names.entrySet())) + "}";
        }
    }
}

