/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree.xpath;

import java.util.Locale;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.InMemoryNodeModel;
import org.apache.commons.configuration2.tree.QueryResult;
import org.apache.commons.configuration2.tree.xpath.ConfigurationAttributePointer;
import org.apache.commons.configuration2.tree.xpath.ConfigurationNodePointer;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestConfigurationAttributePointer {
    private static final String ATTR_NAME = "myAttr";
    private static final String ATTR_VALUE = "myValue";
    private ConfigurationNodePointer<ImmutableNode> parent;
    private ConfigurationAttributePointer<ImmutableNode> pointer;

    @BeforeEach
    public void setUp() throws Exception {
        ImmutableNode.Builder ndBuilder = new ImmutableNode.Builder();
        ndBuilder.name("parent").addAttribute(ATTR_NAME, (Object)ATTR_VALUE);
        ImmutableNode nd = ndBuilder.create();
        this.parent = new ConfigurationNodePointer((Object)nd, Locale.ROOT, new InMemoryNodeModel(nd).getNodeHandler());
        this.pointer = new ConfigurationAttributePointer(this.parent, ATTR_NAME);
    }

    @Test
    void testAttributeIterator() {
        Assertions.assertNull((Object)this.pointer.attributeIterator(new QName(null, "test")));
    }

    @Test
    void testChildIterator() {
        Assertions.assertNull((Object)this.pointer.childIterator(null, false, null));
    }

    @Test
    void testGetBaseValue() {
        Assertions.assertEquals((Object)ATTR_VALUE, (Object)this.pointer.getBaseValue());
    }

    @Test
    void testGetImmediateNode() {
        Object node = this.pointer.getImmediateNode();
        QueryResult proxy = (QueryResult)Assertions.assertInstanceOf(QueryResult.class, (Object)node);
        Assertions.assertTrue((boolean)proxy.isAttributeResult());
        Assertions.assertEquals((Object)this.parent.getConfigurationNode(), (Object)proxy.getNode());
        Assertions.assertEquals((Object)ATTR_NAME, (Object)proxy.getAttributeName());
    }

    @Test
    void testGetLength() {
        Assertions.assertEquals((int)1, (int)this.pointer.getLength());
    }

    @Test
    void testGetName() {
        QName qName = this.pointer.getName();
        Assertions.assertEquals((Object)ATTR_NAME, (Object)qName.getName());
        Assertions.assertNull((Object)qName.getPrefix());
    }

    @Test
    void testGetParentPointer() {
        Assertions.assertSame(this.parent, (Object)this.pointer.getParentPointer());
    }

    @Test
    void testGetValue() {
        Assertions.assertEquals((Object)ATTR_VALUE, (Object)this.pointer.getValue());
    }

    @Test
    void testIsAttribute() {
        Assertions.assertTrue((boolean)this.pointer.isAttribute());
    }

    @Test
    void testIsCollection() {
        Assertions.assertFalse((boolean)this.pointer.isCollection());
    }

    @Test
    void testIsLeaf() {
        Assertions.assertTrue((boolean)this.pointer.isLeaf());
    }

    @Test
    void testSetValue() {
        Assertions.assertThrows(UnsupportedOperationException.class, () -> this.pointer.setValue((Object)"newValue"));
    }

    @Test
    void testTestNode() {
        NodeTypeTest test = new NodeTypeTest(2);
        Assertions.assertTrue((boolean)this.pointer.testNode((NodeTest)test));
        test = new NodeTypeTest(3);
        Assertions.assertFalse((boolean)this.pointer.testNode((NodeTest)test));
    }
}

