/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.functors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.AbstractMockPredicateTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractCompositePredicateTest<T>
extends AbstractMockPredicateTest<T> {
    protected AbstractCompositePredicateTest(T testValue) {
        super(testValue);
    }

    protected final Predicate<T> getPredicateInstance(Boolean ... mockReturnValues) {
        ArrayList<Predicate<T>> predicates = new ArrayList<Predicate<T>>();
        for (Boolean returnValue : mockReturnValues) {
            predicates.add(this.createMockPredicate(returnValue));
        }
        return this.getPredicateInstance(predicates);
    }

    protected abstract Predicate<T> getPredicateInstance(Collection<Predicate<T>> var1);

    protected abstract Predicate<T> getPredicateInstance(Predicate<? super T> ... var1);

    @Test
    public final void nullArrayToGetInstance() {
        Assertions.assertThrows(NullPointerException.class, () -> this.getPredicateInstance((Predicate[])null));
    }

    @Test
    public final void nullCollectionToGetInstance() {
        Assertions.assertThrows(NullPointerException.class, () -> this.getPredicateInstance((Collection)null));
    }

    @Test
    public final void nullElementInArrayToGetInstance() {
        Assertions.assertThrows(NullPointerException.class, () -> this.getPredicateInstance(new Predicate[]{null}));
    }

    @Test
    public final void nullElementsInArrayToGetInstance() {
        Assertions.assertThrows(NullPointerException.class, () -> this.getPredicateInstance(new Predicate[]{null, null}));
    }

    @Test
    public final void nullElementsInCollectionToGetInstance() {
        ArrayList<Object> coll = new ArrayList<Object>();
        coll.add(null);
        coll.add(null);
        Assertions.assertThrows(NullPointerException.class, () -> this.getPredicateInstance(coll));
    }

    public void singleElementArrayToGetInstance() {
        Predicate predicate = this.createMockPredicate(null);
        Predicate<T> allPredicate = this.getPredicateInstance(predicate);
        Assertions.assertSame(predicate, allPredicate, (String)"expected argument to be returned by getInstance()");
    }

    public void singletonCollectionToGetInstance() {
        Predicate predicate = this.createMockPredicate(null);
        Predicate allPredicate = this.getPredicateInstance(Collections.singleton(predicate));
        Assertions.assertSame(predicate, allPredicate, (String)"expected argument to be returned by getInstance()");
    }
}

