/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.util.UUID;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.UUIDConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class UUIDConverterTest {
    private Converter<UUID> converter;

    protected Class<?> getExpectedType() {
        return UUID.class;
    }

    protected Converter<UUID> makeConverter() {
        return new UUIDConverter();
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testSimpleConversion() throws Exception {
        int i;
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from String"};
        Object[] input = new Object[]{"123e4567-e89b-12d3-a456-556642440000", "7dc53df5-703e-49b3-8670-b1c468f47f1f"};
        UUID[] expected = new UUID[]{UUID.fromString("123e4567-e89b-12d3-a456-556642440000"), UUID.fromString("7dc53df5-703e-49b3-8670-b1c468f47f1f")};
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(UUID.class, input[i]), (String)(message[i] + " to URI"));
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(null, input[i]), (String)(message[i] + " to null type"));
        }
        for (i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)input[i], (Object)this.converter.convert(String.class, (Object)expected[i]), (String)(input[i] + " to String"));
        }
    }

    @Test
    public void testUnsupportedType() {
        Assertions.assertThrows(ConversionException.class, () -> this.converter.convert(Integer.class, (Object)"http://www.apache.org"));
    }
}

