/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ContextClassLoaderLocal;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PrimitiveBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.LogFactory;

public class BeanificationTestCase
extends TestCase {
    public static final int MAX_GC_ITERATIONS = 50;

    public static Test suite() {
        return new TestSuite(BeanificationTestCase.class);
    }

    public BeanificationTestCase(String name) {
        super(name);
    }

    public void setUp() {
        ConvertUtils.deregister();
    }

    public void tearDown() {
    }

    public void testBeanUtilsBeanSetInstance() throws Exception {
        Signal signal = new Signal();
        signal.setSignal(1);
        BeanUtilsBean beanOne = new BeanUtilsBean();
        BeanUtilsBean beanTwo = new BeanUtilsBean();
        class SetInstanceTesterThread
        extends Thread {
            private final Signal signal;
            private final BeanUtilsBean bean;

            SetInstanceTesterThread(Signal signal, BeanUtilsBean bean) {
                this.signal = signal;
                this.bean = bean;
            }

            @Override
            public void run() {
                BeanUtilsBean.setInstance((BeanUtilsBean)this.bean);
                this.signal.setSignal(21);
                this.signal.setBean(BeanUtilsBean.getInstance());
            }

            @Override
            public String toString() {
                return "SetInstanceTesterThread";
            }
        }
        SetInstanceTesterThread thread = new SetInstanceTesterThread(signal, beanTwo);
        thread.setContextClassLoader(new TestClassLoader());
        BeanUtilsBean.setInstance((BeanUtilsBean)beanOne);
        BeanificationTestCase.assertEquals((String)"Start thread gets right instance", (Object)beanOne, (Object)BeanUtilsBean.getInstance());
        thread.start();
        thread.join();
        BeanificationTestCase.assertEquals((String)"Signal not set by test thread", (int)21, (int)signal.getSignal());
        BeanificationTestCase.assertEquals((String)"Second thread preserves value", (Object)beanOne, (Object)BeanUtilsBean.getInstance());
        BeanificationTestCase.assertEquals((String)"Second thread gets value it set", (Object)beanTwo, (Object)signal.getBean());
    }

    public void testContextClassloaderIndependence() throws Exception {
        PrimitiveBean bean = new PrimitiveBean();
        BeanUtils.setProperty((Object)bean, (String)"int", (Object)new Integer(1));
        BeanificationTestCase.assertEquals((String)"Wrong property value (1)", (int)1, (int)bean.getInt());
        ConvertUtils.register((Converter)new Converter(){

            public <T> T convert(Class<T> type, Object value) {
                return ConvertUtils.primitiveToWrapper(type).cast(new Integer(5));
            }
        }, Integer.TYPE);
        BeanUtils.setProperty((Object)bean, (String)"int", (Object)new Integer(1));
        BeanificationTestCase.assertEquals((String)"Wrong property value(2)", (int)5, (int)bean.getInt());
        Signal signal = new Signal();
        signal.setSignal(1);
        class TestIndependenceThread
        extends Thread {
            private final Signal signal;
            private final PrimitiveBean bean;

            TestIndependenceThread(Signal signal, PrimitiveBean bean) {
                this.signal = signal;
                this.bean = bean;
            }

            @Override
            public void run() {
                try {
                    this.signal.setSignal(3);
                    ConvertUtils.register((Converter)new Converter(){

                        public <T> T convert(Class<T> type, Object value) {
                            return ConvertUtils.primitiveToWrapper(type).cast(new Integer(9));
                        }
                    }, Integer.TYPE);
                    BeanUtils.setProperty((Object)this.bean, (String)"int", (Object)new Integer(1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.signal.setException(e);
                }
            }

            @Override
            public String toString() {
                return "TestIndependenceThread";
            }
        }
        TestIndependenceThread thread = new TestIndependenceThread(signal, bean);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        BeanificationTestCase.assertNull((String)("Exception thrown by test thread:" + signal.getException()), (Object)signal.getException());
        BeanificationTestCase.assertEquals((String)"Signal not set by test thread", (int)3, (int)signal.getSignal());
        BeanificationTestCase.assertEquals((String)"Wrong property value(3)", (int)9, (int)bean.getInt());
    }

    public void testContextClassLoaderLocal() throws Exception {
        ContextClassLoaderLocal ccll = new ContextClassLoaderLocal();
        ccll.set((Object)new Integer(1776));
        BeanificationTestCase.assertEquals((String)"Start thread sets value", (Object)new Integer(1776), (Object)ccll.get());
        Signal signal = new Signal();
        signal.setSignal(1);
        class CCLLTesterThread
        extends Thread {
            private final Signal signal;
            private final ContextClassLoaderLocal<Integer> ccll;

            CCLLTesterThread(Signal signal, ContextClassLoaderLocal<Integer> ccll) {
                this.signal = signal;
                this.ccll = ccll;
            }

            @Override
            public void run() {
                this.ccll.set((Object)new Integer(1789));
                this.signal.setSignal(2);
                this.signal.setMarkerObject(this.ccll.get());
            }

            @Override
            public String toString() {
                return "CCLLTesterThread";
            }
        }
        CCLLTesterThread thread = new CCLLTesterThread(signal, (ContextClassLoaderLocal<Integer>)ccll);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        BeanificationTestCase.assertEquals((String)"Signal not set by test thread", (int)2, (int)signal.getSignal());
        BeanificationTestCase.assertEquals((String)"Second thread preserves value", (Object)new Integer(1776), (Object)ccll.get());
        BeanificationTestCase.assertEquals((String)"Second thread gets value it set", (Object)new Integer(1789), (Object)signal.getMarkerObject());
    }

    public void testContextClassLoaderUnset() throws Exception {
        BeanUtilsBean beanOne = new BeanUtilsBean();
        ContextClassLoaderLocal ccll = new ContextClassLoaderLocal();
        ccll.set((Object)beanOne);
        BeanificationTestCase.assertEquals((String)"Start thread gets right instance", (Object)beanOne, (Object)ccll.get());
        ccll.unset();
        BeanificationTestCase.assertTrue((String)"Unset works", (!beanOne.equals(ccll.get()) ? 1 : 0) != 0);
    }

    public void testGetByContextClassLoader() throws Exception {
        Signal signal = new Signal();
        signal.setSignal(1);
        class GetBeanUtilsBeanThread
        extends Thread {
            private final Signal signal;

            GetBeanUtilsBeanThread(Signal signal) {
                this.signal = signal;
            }

            @Override
            public void run() {
                this.signal.setSignal(2);
                this.signal.setBean(BeanUtilsBean.getInstance());
                this.signal.setConvertUtils(ConvertUtilsBean.getInstance());
                this.signal.setPropertyUtils(PropertyUtilsBean.getInstance());
            }

            @Override
            public String toString() {
                return "GetBeanUtilsBeanThread";
            }
        }
        GetBeanUtilsBeanThread thread = new GetBeanUtilsBeanThread(signal);
        thread.setContextClassLoader(new TestClassLoader());
        thread.start();
        thread.join();
        BeanificationTestCase.assertEquals((String)"Signal not set by test thread", (int)2, (int)signal.getSignal());
        BeanificationTestCase.assertTrue((String)"Different BeanUtilsBean instances per context classloader", (BeanUtilsBean.getInstance() != signal.getBean() ? 1 : 0) != 0);
        BeanificationTestCase.assertTrue((String)"Different ConvertUtilsBean instances per context classloader", (ConvertUtilsBean.getInstance() != signal.getConvertUtils() ? 1 : 0) != 0);
        BeanificationTestCase.assertTrue((String)"Different PropertyUtilsBean instances per context classloader", (PropertyUtilsBean.getInstance() != signal.getPropertyUtils() ? 1 : 0) != 0);
    }

    public void testMemoryLeak() throws Exception {
        TestClassLoader loader = new TestClassLoader();
        WeakReference<TestClassLoader> loaderReference = new WeakReference<TestClassLoader>(loader);
        BeanUtilsBean.getInstance();
        class GetBeanUtilsBeanThread
        extends Thread {
            BeanUtilsBean beanUtils;
            ConvertUtilsBean convertUtils;
            PropertyUtilsBean propertyUtils;

            GetBeanUtilsBeanThread() {
            }

            @Override
            public void run() {
                this.beanUtils = BeanUtilsBean.getInstance();
                this.convertUtils = ConvertUtilsBean.getInstance();
                this.propertyUtils = PropertyUtilsBean.getInstance();
                LogFactory.releaseAll();
            }

            @Override
            public String toString() {
                return "GetBeanUtilsBeanThread";
            }
        }
        GetBeanUtilsBeanThread thread = new GetBeanUtilsBeanThread();
        WeakReference<GetBeanUtilsBeanThread> threadWeakReference = new WeakReference<GetBeanUtilsBeanThread>(thread);
        thread.setContextClassLoader(loader);
        thread.start();
        thread.join();
        WeakReference<BeanUtilsBean> beanUtilsReference = new WeakReference<BeanUtilsBean>(thread.beanUtils);
        WeakReference<PropertyUtilsBean> propertyUtilsReference = new WeakReference<PropertyUtilsBean>(thread.propertyUtils);
        WeakReference<ConvertUtilsBean> convertUtilsReference = new WeakReference<ConvertUtilsBean>(thread.convertUtils);
        BeanificationTestCase.assertNotNull((String)"Weak reference released early (1)", loaderReference.get());
        BeanificationTestCase.assertNotNull((String)"Weak reference released early (2)", beanUtilsReference.get());
        BeanificationTestCase.assertNotNull((String)"Weak reference released early (3)", propertyUtilsReference.get());
        BeanificationTestCase.assertNotNull((String)"Weak reference released early (4)", convertUtilsReference.get());
        loader = null;
        thread.setContextClassLoader(null);
        thread = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            BeanUtilsBean.getInstance();
            System.gc();
            if (iterations++ > 50) {
                BeanificationTestCase.fail((String)"Max iterations reached before resource released.");
            }
            if (loaderReference.get() == null && beanUtilsReference.get() == null && propertyUtilsReference.get() == null && convertUtilsReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    public void testMemoryLeak2() throws Exception {
        TestClassLoader loader = new TestClassLoader();
        ReferenceQueue queue = new ReferenceQueue();
        WeakReference<TestClassLoader> loaderReference = new WeakReference<TestClassLoader>(loader, queue);
        Integer test = new Integer(1);
        WeakReference<Integer> testReference = new WeakReference<Integer>(test, queue);
        WeakHashMap<TestClassLoader, Integer> map = new WeakHashMap<TestClassLoader, Integer>();
        map.put(loader, test);
        BeanificationTestCase.assertEquals((String)"In map", (Object)test, map.get(loader));
        BeanificationTestCase.assertNotNull((String)"Weak reference released early (1)", loaderReference.get());
        BeanificationTestCase.assertNotNull((String)"Weak reference released early (2)", testReference.get());
        loader = null;
        test = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50) {
                BeanificationTestCase.fail((String)"Max iterations reached before resource released.");
            }
            map.isEmpty();
            if (loaderReference.get() == null && testReference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    public void testMemoryTestMethodology() throws Exception {
        ClassLoader loader = new ClassLoader(((Object)((Object)this)).getClass().getClassLoader()){};
        WeakReference<2> reference = new WeakReference<2>(loader);
        Class<?> myClass = loader.loadClass("org.apache.commons.beanutils.BetaBean");
        BeanificationTestCase.assertNotNull((String)"Weak reference released early", reference.get());
        loader = null;
        myClass = null;
        int iterations = 0;
        int bytz = 2;
        while (true) {
            System.gc();
            if (iterations++ > 50) {
                BeanificationTestCase.fail((String)"Max iterations reached before resource released.");
            }
            if (reference.get() == null) break;
            byte[] b = new byte[bytz];
            bytz *= 2;
        }
    }

    class Signal {
        private Exception e;
        private int signal;
        private BeanUtilsBean bean;
        private PropertyUtilsBean propertyUtils;
        private ConvertUtilsBean convertUtils;
        private Object marker;

        Signal() {
        }

        public BeanUtilsBean getBean() {
            return this.bean;
        }

        public ConvertUtilsBean getConvertUtils() {
            return this.convertUtils;
        }

        public Exception getException() {
            return this.e;
        }

        public Object getMarkerObject() {
            return this.marker;
        }

        public PropertyUtilsBean getPropertyUtils() {
            return this.propertyUtils;
        }

        public int getSignal() {
            return this.signal;
        }

        public void setBean(BeanUtilsBean bean) {
            this.bean = bean;
        }

        public void setConvertUtils(ConvertUtilsBean convertUtils) {
            this.convertUtils = convertUtils;
        }

        public void setException(Exception e) {
            this.e = e;
        }

        public void setMarkerObject(Object marker) {
            this.marker = marker;
        }

        public void setPropertyUtils(PropertyUtilsBean propertyUtils) {
            this.propertyUtils = propertyUtils;
        }

        public void setSignal(int signal) {
            this.signal = signal;
        }
    }

    class TestClassLoader
    extends ClassLoader {
        TestClassLoader() {
        }

        public String toString() {
            return "TestClassLoader";
        }
    }
}

