/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.future;

import io.vertx.core.Expectation;
import io.vertx.core.VertxException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.Listener;
import io.vertx.core.impl.future.Operation;

public class Expect<T>
extends Operation<T>
implements Listener<T> {
    private final Expectation<? super T> expectation;

    public Expect(ContextInternal context, Expectation<? super T> expectation) {
        super(context);
        this.expectation = expectation;
    }

    @Override
    public void onSuccess(T value) {
        Throwable err = null;
        try {
            if (!this.expectation.test(value) && (err = this.expectation.describe(value)) == null) {
                err = new VertxException("Unexpected result: " + value, true);
            }
        }
        catch (Throwable e) {
            err = e;
        }
        if (err != null) {
            this.tryFail(err);
        } else {
            this.tryComplete(value);
        }
    }

    @Override
    public void onFailure(Throwable failure) {
        this.tryFail(failure);
    }
}

