/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.apache.maven.wrapper.Downloader;
import org.apache.maven.wrapper.Logger;

public class DefaultDownloader
implements Downloader {
    private static final int PROGRESS_CHUNK = 500000;
    private static final int BUFFER_SIZE = 10000;
    private final String applicationName;
    private final String applicationVersion;

    public DefaultDownloader(String applicationName, String applicationVersion) {
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.configureProxyAuthentication();
        this.configureAuthentication();
    }

    private void configureProxyAuthentication() {
        if (System.getProperty("http.proxyUser") != null) {
            Authenticator.setDefault(new SystemPropertiesProxyAuthenticator());
        }
    }

    private void configureAuthentication() {
        if (System.getenv("MVNW_USERNAME") != null && System.getenv("MVNW_PASSWORD") != null && System.getProperty("http.proxyUser") == null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(System.getenv("MVNW_USERNAME"), System.getenv("MVNW_PASSWORD").toCharArray());
                }
            });
        }
    }

    @Override
    public void download(URI address, File destination) throws Exception {
        if (destination.exists()) {
            return;
        }
        destination.getParentFile().mkdirs();
        this.downloadInternal(address, destination);
    }

    private void downloadInternal(URI address, File destination) throws Exception {
        URL url = address.toURL();
        URLConnection conn = url.openConnection();
        this.addBasicAuthentication(address, conn);
        String userAgentValue = this.calculateUserAgent();
        conn.setRequestProperty("User-Agent", userAgentValue);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(destination));
             InputStream in = conn.getInputStream();){
            int numRead;
            byte[] buffer = new byte[10000];
            long progressCounter = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                if ((progressCounter += (long)numRead) / 500000L > 0L) {
                    Logger.info(".");
                    progressCounter -= 500000L;
                }
                ((OutputStream)out).write(buffer, 0, numRead);
            }
        }
        Logger.info("");
    }

    private void addBasicAuthentication(URI address, URLConnection connection) throws IOException {
        String userInfo = this.calculateUserInfo(address);
        if (userInfo == null) {
            return;
        }
        if (!"https".equals(address.getScheme())) {
            Logger.warn("WARNING Using HTTP Basic Authentication over an insecure connection to download the Maven distribution. Please consider using HTTPS.");
        }
        connection.setRequestProperty("Authorization", "Basic " + this.base64Encode(userInfo));
    }

    private String base64Encode(String userInfo) {
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            Method getEncoderMethod = loader.loadClass("java.util.Base64").getMethod("getEncoder", new Class[0]);
            Method encodeMethod = loader.loadClass("java.util.Base64$Encoder").getMethod("encodeToString", byte[].class);
            Object encoder = getEncoderMethod.invoke(null, new Object[0]);
            return (String)encodeMethod.invoke(encoder, new Object[]{userInfo.getBytes("UTF-8")});
        }
        catch (Exception java7OrEarlier) {
            try {
                Method encodeMethod = loader.loadClass("javax.xml.bind.DatatypeConverter").getMethod("printBase64Binary", byte[].class);
                return (String)encodeMethod.invoke(null, new Object[]{userInfo.getBytes("UTF-8")});
            }
            catch (Exception java5OrEarlier) {
                throw new RuntimeException("Downloading Maven distributions with HTTP Basic Authentication is not supported on your JVM.", java5OrEarlier);
            }
        }
    }

    private String calculateUserInfo(URI uri) {
        String username = System.getenv("MVNW_USERNAME");
        String password = System.getenv("MVNW_PASSWORD");
        if (username != null && password != null) {
            return username + ':' + password;
        }
        return uri.getUserInfo();
    }

    private String calculateUserAgent() {
        String appVersion = this.applicationVersion;
        String javaVendor = System.getProperty("java.vendor");
        String javaVersion = System.getProperty("java.version");
        String javaVendorVersion = System.getProperty("java.vm.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        return String.format("%s/%s (%s;%s;%s) (%s;%s;%s)", this.applicationName, appVersion, osName, osVersion, osArch, javaVendor, javaVersion, javaVendorVersion);
    }

    private static class SystemPropertiesProxyAuthenticator
    extends Authenticator {
        private SystemPropertiesProxyAuthenticator() {
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(System.getProperty("http.proxyUser"), System.getProperty("http.proxyPassword", "").toCharArray());
        }
    }
}

