/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.sasl.SaslException;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.OutputArchive;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestRecord;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.Follower;
import org.apache.zookeeper.server.quorum.FollowerZooKeeperServer;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerTestBase;
import org.apache.zookeeper.server.quorum.QuorumZooKeeperServer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionUpgradeQuorumTest
extends QuorumPeerTestBase {
    protected static final Logger LOG = LoggerFactory.getLogger(SessionUpgradeQuorumTest.class);
    public static final int CONNECTION_TIMEOUT = ClientBase.CONNECTION_TIMEOUT;
    public static final int SERVER_COUNT = 3;
    private QuorumPeerTestBase.MainThread[] mt;
    private int[] clientPorts;
    private TestQPMainDropSessionUpgrading[] qpMain;

    @BeforeEach
    public void setUp() throws Exception {
        int i;
        LOG.info("STARTING quorum {}", (Object)this.getClass().getName());
        ClientBase.setupTestEnv();
        this.mt = new QuorumPeerTestBase.MainThread[3];
        this.clientPorts = new int[3];
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < 3; ++i2) {
            this.clientPorts[i2] = PortAssignment.unique();
            sb.append("server.").append(i2).append("=127.0.0.1:").append(PortAssignment.unique()).append(":").append(PortAssignment.unique()).append("\n");
        }
        sb.append("localSessionsEnabled=true\n");
        sb.append("localSessionsUpgradingEnabled=true\n");
        String cfg = sb.toString();
        this.qpMain = new TestQPMainDropSessionUpgrading[3];
        for (i = 0; i < 3; ++i) {
            TestQPMainDropSessionUpgrading qp;
            this.qpMain[i] = qp = new TestQPMainDropSessionUpgrading();
            this.mt[i] = new QuorumPeerTestBase.MainThread(i, this.clientPorts[i], cfg, false){

                @Override
                public QuorumPeerTestBase.TestQPMain getTestQPMain() {
                    return qp;
                }
            };
            this.mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPorts[i], CONNECTION_TIMEOUT), (String)("waiting for server " + i + " being up"));
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        LOG.info("STOPPING quorum {}", (Object)this.getClass().getName());
        for (int i = 0; i < 3; ++i) {
            this.mt[i].shutdown();
        }
    }

    @Test
    public void testLocalSessionUpgradeSnapshot() throws IOException, InterruptedException {
        int i;
        int leader = -1;
        int followerA = -1;
        for (int i2 = 2; i2 >= 0; --i2) {
            if (this.mt[i2].main.quorumPeer.leader != null) {
                leader = i2;
                continue;
            }
            if (followerA != -1) continue;
            followerA = i2;
        }
        LOG.info("follower A is {}", (Object)followerA);
        this.qpMain[followerA].setDropCreateSession(true);
        String node = "/node-1";
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + this.clientPorts[followerA], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        SessionUpgradeQuorumTest.waitForOne(zk, ZooKeeper.States.CONNECTED);
        long sessionId = zk.getSessionId();
        try {
            zk.create("/node-1", new byte[2], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            Assertions.fail((String)"expect to failed to upgrade session due to the TestQPMainDropSessionUpgrading is being used");
        }
        catch (KeeperException e) {
            LOG.info("KeeperException when create ephemeral node.", (Throwable)e);
        }
        this.qpMain[followerA].quorumPeer.follower.zk.takeSnapshot(true);
        Thread.sleep(500L);
        for (int i3 = 0; i3 < 3; ++i3) {
            this.mt[i3].shutdown();
        }
        ArrayList<ZooKeeper.States> waitStates = new ArrayList<ZooKeeper.States>();
        waitStates.add(ZooKeeper.States.CONNECTING);
        waitStates.add(ZooKeeper.States.CLOSED);
        this.waitForOne(zk, waitStates);
        for (i = 0; i < 3; ++i) {
            this.mt[i].start();
        }
        for (i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)ClientBase.waitForServerUp("127.0.0.1:" + this.clientPorts[i], CONNECTION_TIMEOUT), (String)("waiting for server " + i + " being up"));
        }
        for (i = 0; i < 3; ++i) {
            ConcurrentHashMap sessions = this.mt[i].main.quorumPeer.getZkDb().getSessionWithTimeOuts();
            Assertions.assertFalse((boolean)sessions.containsKey(sessionId), (String)("server " + i + " should not have global session " + sessionId));
        }
        zk.close();
    }

    @Test
    public void testOnlyUpgradeSessionOnce() throws IOException, InterruptedException, KeeperException {
        String node = "/node-1";
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + this.clientPorts[0], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        SessionUpgradeQuorumTest.waitForOne(zk, ZooKeeper.States.CONNECTED);
        long sessionId = zk.getSessionId();
        QuorumZooKeeperServer server = (QuorumZooKeeperServer)this.mt[0].main.quorumPeer.getActiveServer();
        Request create1 = this.createEphemeralRequest("/data-1", sessionId);
        Request create2 = this.createEphemeralRequest("/data-2", sessionId);
        Assertions.assertNotNull((Object)server.checkUpgradeSession(create1), (String)"failed to upgrade on a ephemeral create");
        Assertions.assertNull((Object)server.checkUpgradeSession(create2), (String)"tried to upgrade again");
        zk.close();
    }

    @Test
    public void testCloseSessionWhileUpgradeOnLeader() throws IOException, KeeperException, InterruptedException {
        int leaderId = -1;
        for (int i = 2; i >= 0; --i) {
            if (this.mt[i].main.quorumPeer.leader == null) continue;
            leaderId = i;
        }
        if (leaderId > 0) {
            this.makeSureEphemeralIsGone(leaderId);
        }
    }

    @Test
    public void testCloseSessionWhileUpgradeOnLearner() throws IOException, KeeperException, InterruptedException {
        int learnerId = -1;
        for (int i = 2; i >= 0; --i) {
            if (this.mt[i].main.quorumPeer.follower == null) continue;
            learnerId = i;
        }
        if (learnerId > 0) {
            this.makeSureEphemeralIsGone(learnerId);
        }
    }

    private void makeSureEphemeralIsGone(int sid) throws IOException, KeeperException, InterruptedException {
        this.qpMain[sid].setSubmitDelayMs(200);
        ZooKeeper zk = new ZooKeeper("127.0.0.1:" + this.clientPorts[sid], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        SessionUpgradeQuorumTest.waitForOne(zk, ZooKeeper.States.CONNECTED);
        String node = "/node-1";
        zk.create("/node-1", new byte[2], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL, new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
            }
        }, null);
        zk.close();
        zk = new ZooKeeper("127.0.0.1:" + this.clientPorts[sid], ClientBase.CONNECTION_TIMEOUT, (Watcher)this);
        SessionUpgradeQuorumTest.waitForOne(zk, ZooKeeper.States.CONNECTED);
        Assertions.assertNull((Object)zk.exists("/node-1", false));
        zk.close();
    }

    private void waitForOne(ZooKeeper zk, ArrayList<ZooKeeper.States> states) throws InterruptedException {
        int iterations = ClientBase.CONNECTION_TIMEOUT / 500;
        while (!states.contains(zk.getState())) {
            if (iterations-- == 0) {
                LOG.info("state is {}", (Object)zk.getState());
                throw new RuntimeException("Waiting too long");
            }
            Thread.sleep(500L);
        }
    }

    private Request createEphemeralRequest(String path, long sessionId) throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        BinaryOutputArchive boa = BinaryOutputArchive.getArchive((OutputStream)boas);
        CreateRequest createRequest = new CreateRequest(path, "data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL.toFlag());
        createRequest.serialize((OutputArchive)boa, "request");
        ByteBuffer bb = ByteBuffer.wrap(boas.toByteArray());
        return new Request(null, sessionId, 1, 15, RequestRecord.fromBytes((ByteBuffer)bb), new ArrayList());
    }

    private static class TestQPMainDropSessionUpgrading
    extends QuorumPeerTestBase.TestQPMain {
        private volatile boolean shouldDrop = false;
        private volatile int submitDelayMs = 0;

        private TestQPMainDropSessionUpgrading() {
        }

        public void setDropCreateSession(boolean dropCreateSession) {
            this.shouldDrop = dropCreateSession;
        }

        public void setSubmitDelayMs(int delay) {
            this.submitDelayMs = delay;
        }

        protected QuorumPeer getQuorumPeer() throws SaslException {
            return new QuorumPeer(){

                protected Leader makeLeader(FileTxnSnapLog logFactory) throws IOException {
                    return new Leader((QuorumPeer)this, new LeaderZooKeeperServer(logFactory, this, this.getZkDb()){

                        public void submitRequestNow(Request si) {
                            if (submitDelayMs > 0) {
                                try {
                                    Thread.sleep(submitDelayMs);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            super.submitRequestNow(si);
                        }
                    });
                }

                protected Follower makeFollower(FileTxnSnapLog logFactory) throws IOException {
                    return new Follower(this, new FollowerZooKeeperServer(logFactory, this, this.getZkDb()){

                        public void submitRequestNow(Request si) {
                            if (submitDelayMs > 0) {
                                try {
                                    Thread.sleep(submitDelayMs);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            super.submitRequestNow(si);
                        }
                    }){

                        protected void request(Request request) throws IOException {
                            if (!shouldDrop) {
                                super.request(request);
                                return;
                            }
                            LOG.info("request is {}, cnxn {}", (Object)request.type, (Object)request.cnxn);
                            if (request.type == -10) {
                                LOG.info("drop createSession request {}", (Object)request);
                                return;
                            }
                            if (request.type == 1 && request.cnxn != null) {
                                CreateRequest createRequest = (CreateRequest)request.readRequestRecord(CreateRequest::new);
                                try {
                                    CreateMode createMode = CreateMode.fromFlag((int)createRequest.getFlags());
                                    if (createMode.isEphemeral()) {
                                        request.cnxn.sendCloseSession();
                                    }
                                }
                                catch (KeeperException keeperException) {
                                    // empty catch block
                                }
                                return;
                            }
                            super.request(request);
                        }
                    };
                }
            };
        }
    }
}

