/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.ProviderRegistry;
import org.apache.zookeeper.server.util.AuthUtil;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class AuthUtilTest {
    @BeforeAll
    public static void beforeClassSetUp() {
        ProviderRegistry.reset();
        System.setProperty("zookeeper.authProvider.sasl", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.authProvider.x509", "org.apache.zookeeper.server.auth.X509AuthenticationProvider");
    }

    @AfterAll
    public static void afterClassTearDown() {
        System.clearProperty("zookeeper.authProvider.sasl");
        System.clearProperty("zookeeper.authProvider.x509");
    }

    @Test
    public void testGetUserFromAllAuthenticationScheme() {
        String user = "zkUser";
        Id id = new Id("digest", user + ":password");
        String result = AuthUtil.getUser((Id)id);
        Assertions.assertEquals((Object)user, (Object)result);
        String principal = "zkCli/hadoop.hadoop.com";
        id = new Id("sasl", principal);
        Assertions.assertEquals((Object)principal, (Object)AuthUtil.getUser((Id)id));
        String ip = "192.168.1.2";
        id = new Id("ip", ip);
        Assertions.assertEquals((Object)ip, (Object)AuthUtil.getUser((Id)id));
        String certificate = "CN=host-192.168.1.2,OU=OrganizationUnit,O=Organization,L=Location,ST=State,C=IN";
        id = new Id("x509", certificate);
        Assertions.assertEquals((Object)certificate, (Object)AuthUtil.getUser((Id)id));
    }

    @Test
    public void testGetUserShouldReturnNullIfAuthenticationNotConfigured() {
        Id id = new Id("invalid Authentication Scheme", "user");
        String result = AuthUtil.getUser((Id)id);
        Assertions.assertNull((Object)result);
    }
}

