/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.internal.wsdl20.extensions.soap;

import java.net.URI;
import org.apache.woden.ErrorReporter;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.WSDLComponent;
import org.apache.woden.wsdl20.extensions.BaseComponentExtensionContext;
import org.apache.woden.wsdl20.extensions.ExtensionProperty;
import org.apache.woden.wsdl20.extensions.http.HTTPAuthenticationScheme;
import org.apache.woden.wsdl20.extensions.http.HTTPConstants;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPConstants;
import org.apache.woden.wsdl20.extensions.soap.SOAPEndpointExtensions;
import org.apache.woden.wsdl20.xml.WSDLElement;
import org.apache.woden.xml.HTTPAuthenticationSchemeAttr;
import org.apache.woden.xml.StringAttr;

public class SOAPEndpointExtensionsImpl
extends BaseComponentExtensionContext
implements SOAPEndpointExtensions {
    public SOAPEndpointExtensionsImpl(WSDLComponent parent, URI extNamespace, ErrorReporter errReporter) {
        super(parent, extNamespace, errReporter);
    }

    public ExtensionProperty[] getProperties() {
        return new ExtensionProperty[0];
    }

    public ExtensionProperty getProperty(String propertyName) {
        return null;
    }

    public HTTPAuthenticationScheme getHttpAuthenticationScheme() {
        Endpoint endpoint = (Endpoint)this.getParent();
        Binding binding = endpoint.getBinding();
        if (binding == null) {
            return null;
        }
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(version) && protocol.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || "1.1".equals(version) && protocol.toString().equals("http://www.w3.org/2006/01/soap11/bindings/HTTP/")) {
            HTTPAuthenticationSchemeAttr scheme = (HTTPAuthenticationSchemeAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_AUTHENTICATION_SCHEME);
            return scheme != null ? scheme.getScheme() : null;
        }
        return null;
    }

    public String getHttpAuthenticationRealm() {
        Endpoint endpoint = (Endpoint)this.getParent();
        Binding binding = endpoint.getBinding();
        if (binding == null) {
            return null;
        }
        SOAPBindingExtensions soapBindExt = (SOAPBindingExtensions)binding.getComponentExtensionContext(SOAPConstants.NS_URI_SOAP);
        String version = soapBindExt.getSoapVersion();
        URI protocol = soapBindExt.getSoapUnderlyingProtocol();
        if (protocol == null) {
            return null;
        }
        if ("1.2".equals(version) && protocol.toString().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/") || "1.1".equals(version) && protocol.toString().equals("http://www.w3.org/2006/01/soap11/bindings/HTTP/")) {
            StringAttr realm = (StringAttr)((WSDLElement)((Object)this.getParent())).getExtensionAttribute(HTTPConstants.Q_ATTR_AUTHENTICATION_REALM);
            return realm != null ? realm.getString() : null;
        }
        return null;
    }
}

