/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPLargeMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPMessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.MessageWriter;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerSenderContext;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;

public interface SenderController {
    public static final MessageWriter REJECTING_MESSAGE_WRITER = new RejectingOutgoingMessageWriter();

    public Consumer init(ProtonServerSenderContext var1) throws Exception;

    public void close(boolean var1) throws Exception;

    default public void close(ErrorCondition error) {
    }

    default public MessageWriter selectOutgoingMessageWriter(ProtonServerSenderContext sender, MessageReference reference) {
        MessageWriter selected = reference.getMessage() instanceof AMQPLargeMessage ? new AMQPLargeMessageWriter(sender) : new AMQPMessageWriter(sender);
        return selected;
    }

    public static class RejectingOutgoingMessageWriter
    implements MessageWriter {
        @Override
        public void writeBytes(MessageReference reference) {
            throw new UnsupportedOperationException("Message was sent to rejecting writer in error");
        }
    }
}

